package.path = package.path ..';./Scripts/DemoScenes/?.lua;'
local sceneEnvironment = require("demosceneEnvironment")

scene = {} --Cambrai EC 1/12 SPA 162

function loadScene(scenePtr)
sceneAPI = sceneEnvironment.getInterface(scenePtr)
sceneAPI:setUpdateFunc('sceneVRUpdate')

--Mirage F1C
scene.m1			= sceneAPI:addModel("mirage-F1", -3, 2.3,-6); --(vers moi, hauteur, longitude)
scene.m1.transform:rotate(2.3,220,-4.3);
scene.m1:setLivery("EC 1 12 Cambresis", "Mirage-F1C-200");
scene.m1:setArgument(0, 1); --front gear
scene.m1:setArgument(1, 0.1); --front gear shocks
scene.m1:setArgument(3, 1); --right gear
scene.m1:setArgument(4, 0.8); --right gear shocks
scene.m1:setArgument(5, 1); --left gear
scene.m1:setArgument(6, 0.8); --left gear shocks
scene.m1:setArgument(23, 1); --Wheel chocks
scene.m1:setArgument(444, 0.6); --12-YB
scene.m1:setArgument(445, 0.7); --12-YB
scene.m1:setArgument(38, 0.9); --Canopy
scene.m1:setArgument(50, 0.5); --Pilot
scene.m1:setArgument(70, 0.1); --Cockpit
scene.m1:setArgument(902, 0.1); --Seat
scene.m1:setArgument(986, 0.1); --seatbox
scene.m1:setArgument(987, 0.2); --perche
scene.m1:setArgument(989, 0.1); --exhaust
scene.m1:setArgument(992, 0.1); --mirror


--Mirage 2000C
scene.m2			= sceneAPI:addModel("m-2000c", -4, 1.68, -4);
scene.m2:setLivery("Cambresis", "m-2000c");
scene.m2:setArgument(0, 1); --front gear
scene.m2:setArgument(1, 0.1); --front gear shocks
scene.m2:setArgument(3, 1); --right gear
scene.m2:setArgument(4, 0.2); --right gear shocks
scene.m2:setArgument(5, 1); --left gear
scene.m2:setArgument(6, 0.2); --left gear shocks
scene.m2:setArgument(15, -1); --right aileron
scene.m2:setArgument(16, -1); --left aileron
scene.m2:setArgument(23, 1); --Wheel chocks
scene.m2:setArgument(24, 1); --plugs
scene.m2:setArgument(442, 0.1); --id 122
scene.m2:setArgument(31, 0.2); --id 122
scene.m2:setArgument(32, 0.2); --id 122
scene.m2:setArgument(444, 1.4); --12-YE
scene.m2:setArgument(38, 0.9); --Canopy
scene.m2:setArgument(50, 0.5); --Pilot
scene.m2:setArgument(90, 0.5); --Tuyere
scene.m2:setArgument(91, 1); --ladder
scene.m2:setArgument(308, 0.1); --supor magic
scene.m2:setArgument(309, 0.2); --support S530
scene.m2:setArgument(312, 0.1); --support bidon
scene.m2:setArgument(315, 0.2); --support S530
scene.m2:setArgument(316, 0.1); --supor magic

--Armement M2000
scene.arm1=sceneAPI:addModel("super-530",0,0,0);
scene.arm1:attachTo(scene.m2,"str_pnt_002");
scene.arm2=sceneAPI:addModel("super-530",0,0,0);
scene.arm2:attachTo(scene.m2,"str_pnt_008");
scene.arm3=sceneAPI:addModel("magic-r550",0,0,0);
scene.arm3:attachTo(scene.m2,"str_pnt_001");
scene.arm4=sceneAPI:addModel("magic-r550",0,0,0);
scene.arm4:attachTo(scene.m2,"str_pnt_009");
scene.reser1=sceneAPI:addModel("M-2000C_05_RP522",0,0,0);
scene.reser1:attachTo(scene.m2,"str_pnt_005");


local cam_level = 1.2

scene.cam = sceneAPI:addCamera(-5, cam_level , 1)
scene.cam:setFov(90)
scene.cam.transform:lookAtPoint(-1, cam_level, -5);

	
scene.flr		= sceneAPI:addModel("shelter_floor", 2.7,0,0);
scene.flr:drawToEnvironment(true);
scene.flr.transform:scale(2,1.5,1.5);

scene.sh		= sceneAPI:addModel("ukrytie_1", 0,0,0); 
scene.sh:serArgument(0, 0.05);
scene.sh:serArgument(3, -1);
scene.sh:drawToEnvironment(true);
scene.sh.transform:scale(2,2,2);

sceneAPI:setSun(math.rad(175), math.rad(355)); -- sun. numbers are altitude/azimuth in degrees
sceneAPI:setCirrus(true); -- clouds

scene.cam:setActive()
end

--[0;1]
local function pingpong(length, t)
local tt = (t%length)*2/length
if tt>1 then tt = 2-tt end
return tt
end


function sceneVRUpdate(t, dt)

end